#include <distribution/mpi/mpi_control_state_handler.h>

namespace Platypus
{

  MPIControlStateHandler::MPIControlStateHandler()
    :   entries_(0)
  {}

  MPIControlStateHandler::~MPIControlStateHandler()
  {}
  
  void MPIControlStateHandler::setup(unsigned entries)
  {

    entries_ = entries;
    states_.resize(entries_,0);
    for(unsigned i=0; i < entries_; i++)
      {
	states_.at(i) = INITIAL;
      }

  }

  void MPIControlStateHandler::setState(unsigned index, unsigned state)
  {
    states_.at(index) = state;
  }

  unsigned MPIControlStateHandler::getState(unsigned index) const
  {
    return states_.at(index);
  }

  /*
    unsigned MPIControlStateHandler::findState(unsigned state) const
    {
    for(unsigned index=0; index < entries_; index++)
    {
    if(states_.at(index) == state)
    return index;
    }
    //obviously, this needs a little work
    return 9999;
  }
  */

}
