/*	$Id: fork_serializer.h 1771 2005-05-16 12:00:38Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef MPI_SERIALIZER_H
#define MPI_SERIALIZER_H

#include <cassert>
#include <vector>
#include <platypus/types_fwd.h>
#include <platypus/types/choice.h>
#include <distribution/mpi/mpi_platypus_types.h>

namespace Platypus
{

  /**
   * Handles the translation of choices and partial assignments into
   * into mpi specific message buffers and visa versa.
   *
   */  
  class MPISerializer
  {
  public:
    MPISerializer(const ProgramInterface& program);
    // returns the number of bytes required to send complete assignment
    size_t bytesRequired() const;

    // remove a message from the message buffer and place it in a choice object
    bool deserialize(DelegatableChoice& dc, const MessageBuffer& buffer) const;

    // translate a choice into a message buffer for transfer from
    // worker to worker
    void serialize(MessageBuffer& buffer, const DelegatableChoice& dc) const;
    
    // following two methods are same as above but for moving
    // answer sets around which are stored in PartialAssigment objects
    void deserialize(PartialAssignment& pa, const MessageBuffer & buffer) const;
    void serialize(MessageBuffer& buffer, const PartialAssignment& pa) const;

  private:
    MPISerializer();

  private:
    const ProgramInterface* program_;
  };
}

#endif
