/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif

#include <operators/lookahead.h>
#include <node.h>
#include <body_node.h>
#include <head_node.h>
#include <graph.h>
#include <heuristic.h>
#include <propagator.h>
namespace NS_NOMORE {

Lookahead::Lookahead(Graph& grp) 
  : Operator()
  , graph_(&grp)
  , propagator_(0) 
  , constraint_(0) {
}

Lookahead::~Lookahead() {
}

void Lookahead::setPropagator(Propagator& prop, Propagator::Mode m) {
  propagator_ = &prop;
  propMode_ = m;
}


bool Lookahead::checkColor(Node &node, Color::ColorValue color) {
  bool result = false;
  // color node as choice point -> a new stack is used
  if (graph_->colorChoicePoint(node, color, Color::plus, ColorOpType::first_choice)) {
    result = propagator_->propagate(propMode_);
  }
  graph_->restoreChoicePoint();
  return result;
}

bool Lookahead::color(Node &node, Color::ColorValue color) {
  if (graph_->colorChoicePointStable(node, color)) {
    return propagator_->propagate(propMode_);
  }
  else {
    return false;
  }
}

bool Lookahead::operator()() {
  assert(constraint_ != 0);
  
  graph_->getEventManager().dispatch(LookaheadExecution(ActivityState::started));

  execute();

  graph_->getEventManager().dispatch(LookaheadExecution(ActivityState::finished));

  return graph_->hasConflict() == false;
  
}


}
