#ifndef NOMORE_EXPANDER_H_INCLUDED
#define NOMORE_EXPANDER_H_INCLUDED

#include <platypus/types/expander.h>
#include <vector>
#include <memory>


namespace Platypus { namespace Nomore {

class NomoreSystem;
class Program;
    

///////////////////////////////////////////////////////////////////////////////
// class Nomore::Expander
// 
// 
///////////////////////////////////////////////////////////////////////////////
class Expander 
    : public Platypus::Expander
    , public Backtrackable
    , public Choosable {
public:
	Expander(const ProgramInterface& program, const DelegatableChoice& dc = DelegatableChoice());
	~Expander();

	typedef Platypus::Expander BaseType;

	// returns true if the expander has unknown atoms
	bool hasUnknown() const;

	// returns true if the expander has detected a conflict
	bool hasConflict() const;

	// returns a PartialModel representation of the internal
	// partial model. 
	PartialAssignment partialAssignment() const;

	size_t unknownAtoms() const;
private:
	Expander(const Expander&);
	Expander& operator=(const Expander&);

	void strategyExpand(const Choice& choice);
	void strategyReinitialize(const DelegatableChoice&);
	void strategyBacktrackTo(const Choice&);
	Choice strategyGetChoice();
	PossibleChoices possibleChoices() const;

	void expandBranch(const DelegatableChoice&);
	void undoUntil(size_t level, bool invert);

	class Impl;

	typedef std::vector<ChoiceId> Choices;
	Choices												choices_;
	const Program*								program_;
	std::auto_ptr<NomoreSystem>		nomore_;
	
};

} }

#endif
