/*	$Id: builder_callback.h 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef BUILDER_CALLBACK_H
#define BUILDER_CALLBACK_H

#include <iosfwd>

class NopStream;
namespace Platypus
{
	class ProgramInterface;
	class CoreDistributionCallback;
	class PlatypusOptions;
	class PlatypusTypesFactory;
	class BuilderCoreCallback
	{
	public:
		virtual ~BuilderCoreCallback()
		{}
		virtual void program(ProgramInterface& prog) = 0;
		virtual void distribution(CoreDistributionCallback& callback) = 0;
		virtual void factory(const PlatypusTypesFactory& factory) = 0;
		virtual void output(NopStream& str) = 0;
		virtual void options(const PlatypusOptions& values) = 0;
		virtual void setup() = 0;
	};

	class BuilderDistributionCallback
	{
	public:
		virtual ~BuilderDistributionCallback()
		{}
		virtual void processCommandLine(int& argc, char** argv)
		{}
		virtual void program(const ProgramInterface& prog) = 0;
		virtual void output(NopStream& str) = 0;
		virtual void options(const PlatypusOptions& values) = 0;
		virtual void setup() = 0;
	};	
}

#endif
