/*	$Id: multi_threaded_core.cpp 2058 2005-06-29 07:52:37Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include <cassert>
#include <platypus/options.h>
#include <platypus/cores/foreman.h>
#include <platypus/factories/core_factory.h>
#include <platypus/factories/registration.h>
#include <platypus/cores/multi_threaded_core.h>

namespace Platypus
{
	const std::string MultiThreadedCore::type_("multi-threaded");

	CoreBase* MultiThreadedCore::create()
	{
		return new MultiThreadedCore();
	}
	MultiThreadedCore::~MultiThreadedCore()
	{}
	MultiThreadedCore::MultiThreadedCore()
		:	foreman_(new Foreman)
		,	assistant_(new ForemanAssistant)
	{}
	void MultiThreadedCore::program(ProgramInterface& prog)
	{
		foreman_->program(prog);
		assistant_->program(prog);
	}
	void MultiThreadedCore::distribution(CoreDistributionCallback& callback)
	{
		foreman_->distribution(callback);
	}
	void MultiThreadedCore::factory(const PlatypusTypesFactory& factory)
	{
		assistant_->factory(factory);
	}
	void MultiThreadedCore::output(NopStream& str)
	{
		assistant_->output(str);
		foreman_->output(str);
	}
	void MultiThreadedCore::options(const PlatypusOptions& values)
	{
		assistant_->options(values);
		foreman_->silent(values.silent());
		foreman_->threads(values.threads());
	}
	void MultiThreadedCore::setup()
	{
		foreman_->assistant(*assistant_);
		foreman_->setup();
	}
	
	void MultiThreadedCore::run()
	{
		foreman_->run();
	}
	
	const std::string& MultiThreadedCore::type() const { return type_; }

	template<>
	void factoryRegistration<MultiThreadedCore>()
	{
		CoreFactory::instance().add("mt", MultiThreadedCore::create, "Use multi-threaded core");
	}
}
