/*	$Id: choice.cpp 2069 2005-06-29 09:54:14Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include <iostream>
#include <algorithm>
#include <iterator>
#include <platypus/types/choice.h>

using namespace std;

namespace Platypus
{
	///////////////////////////////////////////////////////////
	// Choice
	///////////////////////////////////////////////////////////
	Choice::Choice(ChoiceId id, bool positive)
		:	id_(id)
		,	positive_(positive)
	{}
	std::ostream& operator<<(std::ostream& os, const Choice& choice)
	{
		os	<< "Id: " << choice.id() << ": " 
			<< (choice.isPositive() ? '+' : '-');
		return os;
	}

	std::ostream & operator<<(std::ostream & os, const Branch& dc)
	{
		os << "Branch: ";
		std::copy(dc.begin(), dc.end(), std::ostream_iterator<Choice>(os, " "));
		return os;	  
	}
}

