#ifndef MPI_CONTROL_STATE_HANDLER_H
#define MPI_CONTROL_STATE_HANDLER_H

#include <vector>
#include <iostream>
#include <distribution/mpi/mpi_platypus_types.h>

using std::vector;

namespace Platypus
{
  
  class MPIControlStateHandler
    {
    public:
      MPIControlStateHandler();
      ~MPIControlStateHandler();

      void setup(unsigned entries);
      void setState(unsigned index, unsigned state);
      unsigned getState(unsigned index) const;
      unsigned findState(unsigned state) const; //find the first worker with the specified state
      vector<unsigned> * getStates(){ return &states_; }

    private:

      vector<unsigned> states_;
      unsigned entries_;
      
    };

}


#endif
