#ifndef MPI_STATISTICS_H
#define MPI_STATISTICS_H

#include <vector>
#include <iostream>
#include <distribution/mpi/mpi_platypus_types.h>

using std::vector;

namespace Platypus
{

  class MPIStatistics
    {
    public:
      MPIStatistics();
      ~MPIStatistics();
      
      void setup(unsigned indices);
      
      //following methods take care of tracking messages for
      //the entire run and individual precesses
      void incMessagesSent(unsigned index, unsigned long inc = 1);
      void incMessagesReceived(unsigned index, unsigned long inc = 1);
      void incExpanderInits(unsigned index, unsigned long inc=1);
      void incConflicts(unsigned index, unsigned long inc=1);
      void incModels(unsigned index, unsigned long inc=1);
      void incBacktracks(unsigned index, unsigned long inc=1);
      void incThreadDelegations(unsigned index, unsigned long inc=1);
      void incWorkRequestsToMaster(unsigned index, unsigned long inc = 1);
      void incWorkRequestsFromMaster(unsigned index, unsigned long inc = 1);
      void incWorkDenials(unsigned index, unsigned long inc = 1);
      void incWorkDelegationsToMaster(unsigned index, unsigned long inc = 1);
      void incWorkDelegationsFromMaster(unsigned index, unsigned long inc = 1);
      void incDroppedRequests(unsigned index, unsigned long inc = 1);
      
      unsigned long messagesSent() const;
      unsigned long messagesReceived() const;
      unsigned long expanderInits() const;
      unsigned long conflicts() const;
      unsigned long models() const;
      unsigned long backtracks() const;
      unsigned long threadDelegations() const;
      unsigned long workRequestsToMaster() const;
      unsigned long workRequestsFromMaster() const;
      unsigned long workDenials() const;
      unsigned long workDelegationsToMaster() const;
      unsigned long workDelegationsFromMaster() const;
      unsigned long droppedRequests() const;

      unsigned long indexMessagesSent(unsigned index) const;
      unsigned long indexMessagesReceived(unsigned index) const;
      unsigned long indexExpanderInits(unsigned index) const;
      unsigned long indexConflicts(unsigned index) const;
      unsigned long indexModels(unsigned index) const;
      unsigned long indexBacktracks(unsigned index) const;
      unsigned long indexThreadDelegations(unsigned index) const;
      unsigned long indexWorkRequestsToMaster(unsigned index) const;
      unsigned long indexWorkRequestsFromMaster(unsigned index) const;
      unsigned long indexWorkDenials(unsigned index) const;
      unsigned long indexWorkDelegationsToMaster(unsigned index) const;
      unsigned long indexWorkDelegationsFromMaster(unsigned index) const;
      unsigned long indexDroppedRequests(unsigned index) const;
      
      inline void incAnswers(unsigned long inc = 1){ answers_ += inc; }
      inline unsigned long answers(){ return answers_; }

      void checkMaxQueueSize(unsigned queueSize);
      unsigned maxQueueSize() const;

      void checkMaxFiledWorkers(unsigned filedWorkers);
      unsigned maxFiledWorkers();

    private:

      typedef std::vector<unsigned long> IndexedStatistics;

      unsigned indices_;
      
      //global message count
      unsigned long totalMessagesSent_;
      unsigned long totalMessagesReceived_;
      unsigned long totalExpanderInits_;
      unsigned long totalConflicts_;
      unsigned long totalModels_;
      unsigned long totalBacktracks_;
      unsigned long totalThreadDelegations_;
      unsigned long totalWorkRequestsToMaster_;
      unsigned long totalWorkRequestsFromMaster_;
      unsigned long totalWorkDenials_;
      unsigned long totalDelegationsToMaster_;
      unsigned long totalDelegationsFromMaster_;
      unsigned long totalDroppedRequests_;

      IndexedStatistics messagesSent_;
      IndexedStatistics messagesReceived_;
      IndexedStatistics expanderInits_;
      IndexedStatistics conflicts_;
      IndexedStatistics models_;
      IndexedStatistics backtracks_;
      IndexedStatistics threadDelegations_;
      IndexedStatistics workRequestsToMaster_;
      IndexedStatistics workRequestsFromMaster_;
      IndexedStatistics workDenials_;
      IndexedStatistics delegationsToMaster_;
      IndexedStatistics delegationsFromMaster_;
      IndexedStatistics droppedRequests_;
      
      unsigned long answers_;
      unsigned maxQueueSize_;
      unsigned maxFiledWorkers_;

    };

}


#endif
