/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef LIBNOMORE_DETAIL_ALGORITHMS_H
#define LIBNOMORE_DETAIL_ALGORITHMS_H

namespace NS_NOMORE {

//! Contains private implementation details not meant for general use.
namespace DETAIL {

template <class InIter, class OutIter, class Pred>
OutIter copy_if(InIter begin, InIter end, OutIter dest, Pred p) {
	while (begin != end) {
		if (p(*begin))
			*dest++ = *begin;
		++begin;
	}
	return dest;
}

}	// end namespace DETAIL

} // end namespace NS_NOMORE

#endif

