/*	$Id: types_factory.cpp 2705 2005-10-30 08:50:10Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include <cstdlib>
#include <cstring>
#include <sstream>
#include <vector>
#include <program_options/program_options.h>
#include <program_options/value.h>
#include <platypus/exceptions.h>
#include <platypus/factories/builtin_types_registration.h>
#include <platypus/factories/types_factory.h>
#include "makefile_generated_config.h"


using namespace std;
using namespace ProgramOptions;

namespace Platypus
{
	namespace 
	{
#ifdef _WIN32
		const char* const PATH_SEPERATOR = ";";
#else
		const char* const PATH_SEPERATOR = ":";
#endif
	}

	std::auto_ptr<ProgramOptions::OptionGroup> PlatypusTypesFactory::options_(
		new OptionGroup);
	std::auto_ptr<ProgramOptions::OptionValues> PlatypusTypesFactory::values_(
		new OptionValues);
	
	PlatypusTypesFactory& PlatypusTypesFactory::instance()
	{
		static PlatypusTypesFactory instance_;
		return instance_;
	}
	std::string PlatypusTypesFactory::usage() const
	{
		assert(options_.get());
		stringstream s;
		s << *options_;
		return s.str();
	}
	void PlatypusTypesFactory::populateProgramOptions()
	{
		assert(options_.get());

		

		ostringstream p;
		p << "Module path list seperated by '" << PATH_SEPERATOR << "'. Default path: '" << PLATYPUS_BUILTIN_MODULE_DIR << "'";

		options_->addOptions()
			("module-path", value<string>()->defaultValue( PLATYPUS_BUILTIN_MODULE_DIR ), p.str().c_str())
			("report-loading-failure", bool_switch()->defaultValue( false ), "Report failure to open a module")
			
		;
	}
	
	void PlatypusTypesFactory::loadModules(int& argc, char** argv)
	{
		assert(options_.get());
		assert(values_.get());

		values_->store(parseCommandLine(argc, argv, *options_, true));
		const bool reportFailure = option_as<bool>(*values_, "report-loading-failure");
		string path = option_as<string>(*values_, "module-path");

		// path rules:
		// 1. use commandline
		// 2. use ENV
		// 3. use builtin
		const char* envpath = getenv(PLATYPUS_MODULE_PATH);
		if(envpath && path == PLATYPUS_BUILTIN_MODULE_DIR)
			path = envpath;


		vector<char> p(path.c_str(), path.c_str() + path.size() + 1); // include \0
		for(char* token = strtok(&p[0], PATH_SEPERATOR); 
			token; token = strtok(0, PATH_SEPERATOR))
		{
			if(strlen(token) != 0)
			{
				DLLLoader::instance().loadAllInDirectory(token, reportFailure);
			}
		}
	}
	
	
	PlatypusTypesFactory::PlatypusTypesFactory()
	{
		populateProgramOptions();

		distributionFactory().name("distribution factory");
		coreFactory().name("core factory");
		delegatableChoicePolicyFactory().name("delegatable choice policy factory");
		probingPolicyFactory().name("probing policy factory");
		expanderFactory().name("expander factory");
		programFactory().name("program factory");
	}


	namespace
	{
		// this dummy object creates references to the code that should 
		// registers itself during statics initialization.

		BuiltinTypesRegistrar doit;
	}
}
