/*	$Id: local.h 2222 2005-07-19 21:56:58Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef PLATYPUS_LOCAL_H
#define PLATYPUS_LOCAL_H

#include <vector>
#include <iosfwd>
#include <cassert>

#include <platypus/types_fwd.h>
#include <platypus/types/choice.h>
#include <platypus/distribution_base.h>

class NopStream;
namespace Platypus
{
	const char* const LOCAL_DISTRIBUTION_KEY = "local";
	const char* const LOCAL_DISTRIBUTION_DESCRIPTION = "No distribution";
	class Local	: public DistributionBase
	{
	public:
		Local();
		static DistributionBase* create();
	protected: // Builder
		void program(const ProgramInterface& prog);
		void output(NopStream& str);
		void options(const PlatypusOptions& values);
		void setup();
	protected: // CoreCallback
		bool shutdown();
		void teardown() {}
		bool delegate(const DelegatableChoice& dc);
		bool needDelegatableChoice() { return false; }
		void fileDelegatableChoiceRequest();
		void cancelDelegatableChoiceRequest();
		bool hasDelegatableChoice() 
		{ 
			return !branchesToDo_.empty();
		}
		DelegatableChoice delegatableChoice();
		void answerSet(const PartialAssignment& pa);
		void incExpanderInitializations(size_t inc = 1)
		{
			expanderInits_ += inc;
		}
		void incConflicts(size_t inc = 1)
		{
			conflicts_ += inc;
		}
		void incBacktracks(size_t inc = 1)
		{
			backtracks_ += inc;
		}
		void incAnswerSets(size_t inc = 1)
		{
			stableModels_ += inc;
		}
		int id() const { return 0; }
		void incThreadDelegations(size_t inc = 1) { delegations_ += inc; }
	public: // PlatypusAlgorithmCallback
		bool print() const { return true; }
	private: // PlatypusAlgorithmCallback
		void terminate() { shutdown_ = true; }
		std::ostream& print(std::ostream& os) const;
		const std::string& type() const { return type_; }
		size_t expanderInitializations() const { return expanderInits_; }
		size_t conflicts() const { return conflicts_; }
		size_t answerSetsFound() const { return stableModels_; }
		size_t backtracks() const { return backtracks_; }
		size_t threads() const { return threads_; }
		size_t threadDelegations() const { return delegations_; }
		void disableAnswerSetPrinting();
		void enableAnswerSetPrinting();
		void printer(AnswerSetPrinterBase& pr);
	private:
		bool enoughAnswerSets() const;
		bool enoughPrinted() const;
	private:	
		typedef std::vector<DelegatableChoice> BranchesToDo;
		const std::string type_;
		NopStream* os_;
		AnswerSetPrinterBase* printer_;
		BranchesToDo branchesToDo_;
		const ProgramInterface* program_;
		size_t requestedAnswerSets_;
		size_t printedAnswerSets_;
		size_t expanderInits_, conflicts_, stableModels_, backtracks_, threads_, delegations_;
		int dcRequestCount_;
		volatile bool shutdown_;
		bool suppressAnswerSets_, cannotFullfillRequest_;
	};
}

#endif
