/*	$Id: types.h 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef SEARCH_SPACE_H
#define SEARCH_SPACE_H

#include <memory>
#include <vector>
#include <bin_tree.h>
#include <recycle_allocator.h>
#include <platypus/types/choice.h>

namespace Platypus
{
	class ChoicesToDo;
	
	class SearchSpaceUserData
	{
	public:
		virtual ~SearchSpaceUserData() {}
	};
	
	namespace detail
	{
		class Node
		{
			friend class Platypus::ChoicesToDo;
		public:
			Node(ChoiceId id);
			ChoiceId id() const;
			bool active() const;
			//SearchSpaceUserData* getUserData() { return userData_.get(); }
			//void setUserData(SearchSpaceUserData* f) { userData_.reset(f); }
		private:
			void active(bool b);
		private:
			//std::auto_ptr<SearchSpaceUserData> userData_;
			ChoiceId id_;
			bool active_;
		};
	}

	class SearchSpace
	{
	public:
		typedef detail::Node node_type;
		typedef toolbox::bin_tree<
			node_type, 
			toolbox::node_recycle_allocator< std::allocator<node_type> >
		> tree_type;
		typedef tree_type::cursor cursor;
		typedef tree_type::const_cursor const_cursor;
		typedef toolbox::bin_tree_leafs_only_tag leafs_only;
		typedef toolbox::bin_tree_inorder_tag inorder;
		typedef toolbox::bin_tree_preorder_tag preorder;

		typedef toolbox::bin_tree_forward_iterator<node_type, leafs_only> leaf_iterator;
		
		leaf_iterator leafBegin();
		leaf_iterator leafEnd();
		
		SearchSpace(const Branch& = Branch());
		cursor integrate(const Branch&);
		cursor root() const;
		Branch extract(cursor c);
		Branch branch(cursor lower) const;
		Branch branch(cursor lower,  cursor higher) const;
		cursor add(cursor c, const Choice& choice);
		
		cursor close(cursor c);
		bool empty() const;
		double size() const;

		template<class Tag>
		inline toolbox::bin_tree_forward_iterator<node_type, Tag> begin()
		{
			return space_.begin<Tag>();
		}

		template<class Tag>
		inline toolbox::bin_tree_forward_iterator<node_type, Tag> end()
		{
			return space_.end<Tag>();
		}
		template<class Tag>		
		struct iterator_type
		{
			typedef toolbox::bin_tree_forward_iterator<node_type, Tag> iterator;
		};
	private:
		static double size(const_cursor c, double value);
		static void findLastCommonNode(cursor& c, Branch::const_iterator& it, Branch::const_iterator END);
		cursor integrate(cursor c, Branch::const_iterator it, Branch::const_iterator END);
		Branch stackToBranch() const;
		void packStack(cursor from, cursor to) const;
	private:
		typedef std::vector<Choice> ChoiceStack;
		tree_type space_;
		mutable ChoiceStack speedup_stack_;
		bool empty_;
	};
}

#endif
