/*
Copyright (c) 2006, Jean Gressmann All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

    * 	Redistributions of source code must retain the above copyright
    	notice, this list of conditions and the following disclaimer. 
    *	Redistributions in binary form must reproduce the above copyright
		notice, this list of conditions and the following disclaimer in the
		documentation and/or other materials provided with the distribution.
    * 	The names of its contributors may not be used to endorse or promote products
		derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include "config.h"
#include "lowercase.h"

#ifdef PT_HAVE_SUNOS

#include <sys/systeminfo.h>
#include <string>
#include <cassert>
#include "system.h"

using namespace std;
//long sysinfo(int command, char *buf, long count);

namespace
{
	string info(int cmd)
	{
		char buf[1024];
		memset(buf, 0, sizeof(buf));
		sysinfo(cmd, buf, sizeof(buf));
		return string(lowercase(buf));
	}

	string system()
	{
		return info(SI_SYSNAME);
	}

	string machine()
	{
		string arch(info(SI_MACHINE));
		arch += ' ';
		arch += info(SI_ARCHITECTURE);
		return arch;
	}

	string isalist()
	{
		return info(SI_ISALIST);
	}
}

void getSystemInformation(system_information_t& info)
{
	info.machine_ = machine();
	info.machine_details_ = isalist();
	info.os_ = system();
}

#endif // HAVE_SUNOS

