/*
Copyright (c) 2006, Jean Gressmann All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

    * 	Redistributions of source code must retain the above copyright
    	notice, this list of conditions and the following disclaimer. 
    *	Redistributions in binary form must reproduce the above copyright
		notice, this list of conditions and the following disclaimer in the
		documentation and/or other materials provided with the distribution.
    * 	The names of its contributors may not be used to endorse or promote products
		derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
 
#ifndef PT_NATIVE_ATOMIC_NUMBER_H
#define PT_NATIVE_ATOMIC_NUMBER_H

#ifndef PT_ARCH_COMMON_INCLUDED
#	error "Architectural types and functions must be included first!"
#endif 

namespace PortableThreads 
{
	namespace LockFree
	{
		namespace ArchSpecific
		{
			template<unsigned BITS>
			class PTAtomicNumber
			{
			public:
				typedef typename PortableThreads::Private::PTSizeToType<BITS / 8>::int_t int_t;
				PTAtomicNumber(int_t v = 0)
					:	value_(v)
				{}
				inline int_t dec(int_t value = 1)
				{
					return Private::pt_atomic_sub(&value_, value);
				}
				inline int_t inc(int_t value = 1)
				{
					return Private::pt_atomic_add(&value_, value);
				}
				inline int_t get() const
				{
					return value_;
				}
				inline void set(int_t v)
				{
					Private::pt_atomic_set(&value_, v);
				}
				inline bool cas(int_t newValue, int_t oldValue)
				{
					return Private::pt_atomic_cas(&value_, newValue, oldValue);
				}
			private:
				volatile int_t value_;
			};
		}
	}
}


#endif
