/*
Copyright (c) 2006, Jean Gressmann All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

    * 	Redistributions of source code must retain the above copyright
    	notice, this list of conditions and the following disclaimer. 
    *	Redistributions in binary form must reproduce the above copyright
		notice, this list of conditions and the following disclaimer in the
		documentation and/or other materials provided with the distribution.
    * 	The names of its contributors may not be used to endorse or promote products
		derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef NATIVE_POINTER_LLSC_H
#define NATIVE_POINTER_LLSC_H

#ifndef PT_ARCH_COMMON_INCLUDED
#	error "Architectural types and functions must be included first!"
#endif 

#define PT_POINTER_LLSC_INCLUDED

namespace PortableThreads 
{
	namespace LockFree
	{
		namespace Private
		{
			template<class Traits>
			class PointerLLSC
			{
			public:
				typedef typename Traits::token_t token_t;
				typedef typename Traits::int_t large_int_t;
				typedef pt_pointer_t int_t;
			public:
				explicit
				PointerLLSC(int_t p = 0, int_t u = 0)
					:	value_(0)
				{
					assign(p, u);
				}
				explicit
				PointerLLSC(const token_t& token)
					:	value_(0)
				{
					assign(token);
				}
				inline token_t ll() const
				{
					const large_int_t v = pt_atomic_ll(&value_);
					return token_t(
						static_cast<int_t>(Traits::pointer(v)), 
						0,
						static_cast<int_t>(Traits::userbits(v)));
				}
				inline bool sc(token_t& nv, const token_t& ov)
				{
					return pt_atomic_sc(
						&value_,
						Traits::multiplex(nv.pointer(), nv.userbits()));
				}
				inline bool vl(const token_t& fToken) const
				{
					return fToken == get();
				}
				inline token_t get() const
				{
					const large_int_t v = value_;
					return token_t(
						static_cast<int_t>(Traits::pointer(v)), 
						0,
						static_cast<int_t>(Traits::userbits(v)));
				}
				inline void assign(int_t p, int_t u)
				{
					value_ = Traits::multiplex(p, u);
				}
				inline void assign(const token_t& t)
				{
					assign(t.pointer(), t.userbits());
				}
			private:
				PointerLLSC(const PointerLLSC&);
				PointerLLSC operator=(const PointerLLSC&);
			private:
				volatile large_int_t value_;
			};
		}
	}
}

#endif
