/*
Copyright (c) 2006, Jean Gressmann All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

    * 	Redistributions of source code must retain the above copyright
    	notice, this list of conditions and the following disclaimer. 
    *	Redistributions in binary form must reproduce the above copyright
		notice, this list of conditions and the following disclaimer in the
		documentation and/or other materials provided with the distribution.
    * 	The names of its contributors may not be used to endorse or promote products
		derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef SPARC_64_V9_GCC_H
#define SPARC_64_V9_GCC_H

#ifndef __GNUC__
#	error "You must use a GNU C++ compatible compiler in order to use this header file!"
#endif

#define PT_HAVE_CAS

#include <portablethreads/arch/64-gcc.h>
#include <portablethreads/arch/sparc-v8plus-gcc-common.h>

namespace PortableThreads 
{
	namespace LockFree
	{
		namespace Private
		{
			// Assembler functions are straight from the linux kernel
			
			inline int64 pt_atomic_cas_return_memory(volatile int64* mem, int64 nv, int64 ov)
			{
				__asm__ __volatile__(
					"casx [%2], %3, %0 \n\t"
					"membar #StoreLoad | #StoreStore \n\t"
					: "=&r" (nv)
					: "0" (nv), "r" (mem), "r" (ov)
					: "memory");

				return nv;
			}

			inline uint64 pt_ticks()
			{
				uint64 ret;
				__asm__ ("rd %%tick, %0 \n\t" : "=r"(ret) );
				return ret;
			}


			const unsigned HARDWARE_POINTER_BITS = 44;
			const unsigned ALIGNMENT_BITS = 3;
		}
	}
}

#include <portablethreads/arch/arch-common.h>
#include <portablethreads/arch/native-atomic-arithmetic-common.h>
#include <portablethreads/arch/native-pointer-cas.h>
#include <portablethreads/arch/native-atomic-number.h>
#include <portablethreads/arch/free-high-bits-muxer.h>
#include <portablethreads/arch/cas-based-pointer-llsc.h>

namespace PortableThreads
{
	namespace LockFree
	{
		namespace Private
		{
			/*
			UltraSPARC-II Manual
			UltraSPARC-IIi implements a 44-bit virtual address space in two equal halves at the
			extreme lower and upper portions of the full 64-bit virtual address space. Virtual
			addresses between 0000 0800 0000 0000(16) and FFFF F7FF FFFF FFFF(16), inclusive, are
			termed out of range for UltraSPARC-IIi and are illegal. (In other words, virtual
			address bits VA<63:43> must be either all zeros or all ones.) FIGURE 4-2 on page 25
			illustrates the UltraSPARC-IIi virtual address space.
			*/
			
			template<unsigned USER_BITS, unsigned ALIGNMENT = ALIGNMENT_BITS>
			struct PTPointerCASType
			{
				typedef PointerCAS< FreeHighBitsMuxer<int64, 64, HARDWARE_POINTER_BITS, ALIGNMENT, USER_BITS> > PTPointerCAS;
			};

			typedef PTPointerCASType<0>::PTPointerCAS PTPointerCAS;

			template<unsigned USER_BITS, unsigned ALIGNMENT = ALIGNMENT_BITS>
			struct PTPointerLLSCType
			{
				typedef PointerLLSC< FreeHighBitsMuxer<int64, 64, HARDWARE_POINTER_BITS, ALIGNMENT, USER_BITS> > PointerLLSC;
			};

			typedef PTPointerLLSCType<0>::PointerLLSC PTPointerLLSC;
		}
	}
}


#endif
