/*
Copyright (c) 2006, Jean Gressmann All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

    * 	Redistributions of source code must retain the above copyright
    	notice, this list of conditions and the following disclaimer. 
    *	Redistributions in binary form must reproduce the above copyright
		notice, this list of conditions and the following disclaimer in the
		documentation and/or other materials provided with the distribution.
    * 	The names of its contributors may not be used to endorse or promote products
		derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef PT_BARRIER_H
#define PT_BARRIER_H
#include <portablethreads/config.h>
#include <portablethreads/semaphore.h>
#include <portablethreads/lockfree/atomic_number.h>

#include <portablethreads/warning_header.h>

namespace PortableThreads 
{
	/*! \class PTBarrier barrier.h portablethreads/barrier.h
		\brief Implements a barrier at which a number of threads wait until the last thread arrives.
	*/
	class LIBPORTABLETHREADS_API PTBarrier
	{
	public:
		~PTBarrier();
		/*! \brief Create a barrier
			
			\param n Create that blocks \a n threads until the last thread calls wait().

			\exception PTParameterError \a n must not be zero.
		*/
		PTBarrier(unsigned n);
		/*! \brief Wait at the barrier.

			Causes the first N (see PTBarrier(unsigned)) threads to block.
			The last of the N threads unlocks the N-1 waiting threads and
			resets the barrier.

			\retval true A thread waited successfully at the barrier.
			\retval false A thread called wait() while N threads were 
				already waiting.
		*/
		bool wait();
	private:
		PTBarrier();
	private:
		typedef LockFree::PTAtomicNumber::int_t int_t;
		const int_t size_;
		LockFree::PTAtomicNumber counter_;
		PTSemaphore sem_;
	};
}

#include <portablethreads/warning_footer.h>

#endif
