/*
Copyright (c) 2006, Jean Gressmann All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

    * 	Redistributions of source code must retain the above copyright
    	notice, this list of conditions and the following disclaimer. 
    *	Redistributions in binary form must reproduce the above copyright
		notice, this list of conditions and the following disclaimer in the
		documentation and/or other materials provided with the distribution.
    * 	The names of its contributors may not be used to endorse or promote products
		derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef PT_CONFIG_H
#define PT_CONFIG_H

// check for externally provided defines for os & arch
#if defined(PT_WINDOWS) || defined(PT_LINUX) || defined(PT_SOLARIS) || defined(PT_FREEBSD) || defined(PT_DARWIN)
#	define PT_OS_DEFINED
#endif
#if defined(PT_X86) || defined(PT_PPC) || defined(PT_IA64) || defined(PT_SPARC)
#	define PT_ARCH_DEFINED
#endif

// Windows detection
#if defined(_WIN32) || defined(_WIN64) || defined(_MSC_VER) || defined(__MINGW32__) || defined(__DMC__)
#	ifndef PT_OS_DEFINED
#		define PT_WINDOWS
#	endif
#	ifndef PT_ARCH_DEFINED
#		define PT_X86
#	endif
#endif

// Machine detection (windows compilers)
#if defined(_WIN32) && !defined(_WIN64)
#	ifndef PT_NATIVE_WORD
#		define PT_NATIVE_WORD 32
#	endif
#endif

#if defined(_WIN32) && defined(_WIN64)
#	ifndef PT_NATIVE_WORD // in case we don't want to specify ourselves, assume 64 bit mode
#		define PT_NATIVE_WORD 64
#	endif
#endif

// Machine detection (GCC)
#ifdef __GNUC__
// os
#	ifdef __linux__
#		ifndef PT_OS_DEFINED
#			define PT_LINUX
#		endif
#	endif
#	ifdef __APPLE__
#		ifndef PT_OS_DEFINED
#			define PT_DARWIN
#		endif
#	endif
// arch
#	ifdef __LP64__ // generic 64 bit detection
#		ifndef PT_NATIVE_WORD
#			define PT_NATIVE_WORD 64
#		endif
#	endif
#	if defined(__x86_64__) || defined(__amd64__)
#		ifndef PT_ARCH_DEFINED
#			define PT_X86
#		endif
#		ifndef PT_NATIVE_WORD
#			define PT_NATIVE_WORD 64
#		endif
#	endif
#	if defined(__i386__) || defined(__i486__) || defined(__i586__) || defined(__i686__)
#		ifndef PT_ARCH_DEFINED
#			define PT_X86
#		endif
#		ifndef PT_NATIVE_WORD
#			define PT_NATIVE_WORD 32
#		endif
#	endif
#	ifdef __ppc64__
#		ifndef PT_ARCH_DEFINED
#			define PT_PPC
#		endif
#		ifndef PT_NATIVE_WORD
#			define PT_NATIVE_WORD 64
#		endif
#	endif
#	if defined(__ppc__) || defined(__powerpc__)
#		ifndef PT_ARCH_DEFINED
#			define PT_PPC
#		endif
#		ifndef PT_NATIVE_WORD
#			define PT_NATIVE_WORD 32
#		endif
#	endif
#	if defined(__sparc_v9__)
#		ifndef PT_ARCH_DEFINED
#			define PT_SPARC
#		endif
#		ifndef PT_NATIVE_WORD
#			define PT_NATIVE_WORD 64
#		endif
#		if !defined(PT_V8) &&! defined(PT_V8PLUS) &&! defined(PT_V9) 
#			define PT_V9
#		endif
#	endif
#	if defined(__sparc__)
#		ifndef PT_ARCH_DEFINED
#			define PT_SPARC
#		endif
#		ifndef PT_NATIVE_WORD
#			define PT_NATIVE_WORD 32
#		endif
#		if !defined(PT_V8) &&! defined(PT_V8PLUS) &&! defined(PT_V9) 
#			define PT_V8
#		endif
#	endif
#endif


// assume Unix by default
#if !defined(PT_WINDOWS) && !defined(PT_UNIX)
#	define PT_UNIX
#endif


// Flag errors...
#if !defined(PT_WINDOWS) && !defined(PT_UNIX)
#	error "You need to define either PT_WINDOWS, or PT_UNIX!"
#endif
#if !defined(PT_NATIVE_WORD)
#	error "You need to define PT_NATIVE_WORD to be either 32 or 64!"
#endif
#if !(defined(PT_X86) || defined(PT_PPC) || defined(PT_IA64) || defined(PT_SPARC))
#	error "You need to define either PT_PPC, PT_X86, PT_SPARC, or PT_IA64!"
#endif

// DLL crap, this is only necessary for the VC
#ifdef _MSC_VER
#	ifdef LIBPORTABLETHREADS_EXPORTS
#		define LIBPORTABLETHREADS_API __declspec(dllexport)
#	else
#		define LIBPORTABLETHREADS_API __declspec(dllimport)
#	endif
#else
#	define LIBPORTABLETHREADS_API 
#endif

// architecture & os specific code

#ifdef _MSC_VER
#	if PT_NATIVE_WORD == 32
#		include <portablethreads/arch/x86-32-msvc.h>
#		define PT_COMPATIBLE_FOUND
#	endif
#endif
#ifdef __MINGW32__
#	if PT_NATIVE_WORD == 32
#		include <portablethreads/arch/x86-32-mingw.h>
#	define PT_COMPATIBLE_FOUND
#		endif
#endif
#ifdef __DMC__ // Digital Mars
#	if PT_NATIVE_WORD == 32
#		include <portablethreads/arch/x86-32-dmc.h>
#		define PT_COMPATIBLE_FOUND
#	endif
#endif
#ifdef __GNUC__
#	ifdef PT_PPC
#		if PT_NATIVE_WORD == 32
#			include <portablethreads/arch/ppc-32-gcc.h>
#			define PT_COMPATIBLE_FOUND
#		endif
#		if PT_NATIVE_WORD == 64
#			error "Unsupported due to unknown pointer layout"
#			include <portablethreads/arch/ppc-64-gcc.h>
#			define PT_COMPATIBLE_FOUND
#		endif			
#	endif
#	ifdef PT_X86
#		if PT_NATIVE_WORD == 32
#			include <portablethreads/arch/x86-32-gcc.h>
#			define PT_COMPATIBLE_FOUND
#		endif
#		if PT_NATIVE_WORD == 64
#			include <portablethreads/arch/x86-64-gcc.h>
#			define PT_COMPATIBLE_FOUND
#		endif			
#	endif
#	ifdef PT_SPARC
#		if PT_NATIVE_WORD == 32
#			if defined(PT_V9) || defined(PT_V8PLUS)
#				include <portablethreads/arch/sparc-32-v8plus-gcc.h>
#				define PT_COMPATIBLE_FOUND
#			endif
#			ifdef PT_V8
#				include <portablethreads/arch/sparc-32-v8-gcc.h>
#				define PT_COMPATIBLE_FOUND
#			endif
#		endif
#		if PT_NATIVE_WORD == 64
#			ifdef PT_V9
#				include <portablethreads/arch/sparc-64-v9-gcc.h>
#				define PT_COMPATIBLE_FOUND
#			endif
#		endif
#	endif
#	ifdef PT_IA64
#		if PT_NATIVE_WORD == 64
#			include <portablethreads/arch/ia-64-gcc.h>
#			define PT_COMPATIBLE_FOUND
#		endif			
#	endif
#endif

// Check if we have detected a compatible configuration
#ifndef PT_COMPATIBLE_FOUND
#	error "You are trying to compile PortableThreads with an unsupported compiler/define combination!"
#else
#	undef PT_COMPATIBLE_FOUND
#endif

// remove marker defines
#ifdef PT_OS_DEFINED
#	undef PT_OS_DEFINED
#endif
#ifdef PT_ARCH_DEFINED
#	undef PT_ARCH_DEFINED
#endif


// See to it that type definitions (int sizes, how to do pointer cas)
// are properly included
#if !defined(PT_ARCH_COMMON_INCLUDED) || !defined(PT_POINTER_CAS_INCLUDED)
#	error "Architectural files not properly included! Check platform defines!"
#else
#	undef PT_ARCH_COMMON_INCLUDED
#	undef PT_POINTER_CAS_INCLUDED
#endif


#endif
