/*
Copyright (c) 2006, Jean Gressmann All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

    * 	Redistributions of source code must retain the above copyright
    	notice, this list of conditions and the following disclaimer. 
    *	Redistributions in binary form must reproduce the above copyright
		notice, this list of conditions and the following disclaimer in the
		documentation and/or other materials provided with the distribution.
    * 	The names of its contributors may not be used to endorse or promote products
		derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef PT_MEMORY_CHUNK_BATCH_H
#define PT_MEMORY_CHUNK_BATCH_H

#include <portablethreads/config.h>

namespace PortableThreads
{
	namespace LockFree
	{
		namespace Private
		{
			LIBPORTABLETHREADS_API void pt_destroy_memory_chunk_batch(void* memory);
			LIBPORTABLETHREADS_API void pt_setup_memory_chunk_batch(void* memory, pt_uint_t memorySize, pt_uint_t chunkSize);
			LIBPORTABLETHREADS_API void* pt_alloc_from_memory_chunk_batch(void* memory);
			LIBPORTABLETHREADS_API bool pt_can_free_memory_chunk_batch(void* memory);
			LIBPORTABLETHREADS_API void pt_free_to_memory_chunk_batch(void* mem);
			LIBPORTABLETHREADS_API void pt_set_userdata_on_memory(void* mem, uint32 fUserData);
			LIBPORTABLETHREADS_API uint32 pt_get_userdata_from_memory(void* mem);
			LIBPORTABLETHREADS_API bool pt_validate_write_to_memory_chunk(void* mem, pt_uint_t bytes);
			LIBPORTABLETHREADS_API pt_uint_t pt_get_optimal_size_of_memory_chunk_batch(pt_uint_t ChunkSize);
			LIBPORTABLETHREADS_API pt_uint_t pt_get_memory_chunk_header_size();
			LIBPORTABLETHREADS_API void pt_create_memory_chunk_header(void* fMem);
		}
	}
}

#endif // PT_MEMORY_CHUNK_BATCH_H
