/*
Copyright (c) 2006, Jean Gressmann All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

    * 	Redistributions of source code must retain the above copyright
    	notice, this list of conditions and the following disclaimer. 
    *	Redistributions in binary form must reproduce the above copyright
		notice, this list of conditions and the following disclaimer in the
		documentation and/or other materials provided with the distribution.
    * 	The names of its contributors may not be used to endorse or promote products
		derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef PT_MUTEX_H
#define PT_MUTEX_H
#include <portablethreads/config.h>
#ifdef PT_WINDOWS
#	include <portablethreads/win32/mutex.h>
#endif
#ifdef PT_UNIX
#	include <portablethreads/unix/mutex.h>
#endif

#include <portablethreads/warning_header.h>

namespace PortableThreads
{
	/*! \class PTMutex mutex.h portablethreads/mutex.h
		\brief Mutex

		PTMutex implements a mutual exclusion object. Threads that are waiting to
		acquire the object are suspended in their execution until the object becomes
		available.
	*/
	class PTMutex : private OSSpecific::PTMutex
	{
		typedef OSSpecific::PTMutex Base;
	public:
		/*! \brief Create a mutex object

			\param locked If true the mutex is created locked, unlocked otherwise.

			\exception PTResourceError Thrown if a operating system mutex cannot be created.
		*/
		PTMutex(bool locked = false)
			:	Base(locked)
		{}
		/*! \brief Attempt to lock the mutex.

			\retval true The calling thread successfully locked (acquired) the mutex.
			\retval false Locking attempt failed.
		*/
		inline bool tryLock() 
		{ 
			return Base::tryLock();		
		}
		/*! \brief Lock the mutex.

			The calling thread is blocked until it has successfully locked (acquired)
			the mutex.
		*/
		inline void lock() 
		{ 
			Base::lock();	
		}
		/*! \brief Unlock the mutex.

			If the mutex was unlocked this call has no effect. If the mutex was
			locked it is unlocked.
			In case there are threads waiting to acquire the mutex, one of the threads
			calls to lock() or tryLock() succeeds when the unlock() call takes effect.
		*/
		inline void unlock() 
		{ 
			Base::unlock();	
		}
	};
}

#include <portablethreads/warning_footer.h>

#endif
