/*
Copyright (c) 2006, Jean Gressmann All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

    * 	Redistributions of source code must retain the above copyright
    	notice, this list of conditions and the following disclaimer. 
    *	Redistributions in binary form must reproduce the above copyright
		notice, this list of conditions and the following disclaimer in the
		documentation and/or other materials provided with the distribution.
    * 	The names of its contributors may not be used to endorse or promote products
		derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
 
#include <portablethreads/unix/thread.h>
#include <cstdio>
#include <cassert>
#include <signal.h>
#include <errno.h>
#include <string.h>

namespace PortableThreads 
{
	namespace 
	{
		void disableSignals()
		{
			// Disable all signals for this thread. Signals are handled in the main thread.
			sigset_t allSignals, temp;
			sigfillset(&allSignals);
			if(pthread_sigmask(SIG_BLOCK, &allSignals, &temp) != 0)
				std::printf("[PThread] Could not disable signals. Reason: %s\n", strerror(errno));
		}
	}
	void* PThread::entry(void* arg)
	{
		disableSignals();

		// set id in case this threads needs to use it an the thread that
		// created it did not yet return from pthread_create().
		OSThreadTraits::thread_t* thread = static_cast<OSThreadTraits::thread_t*>(arg);
		assert(thread);
		thread->thread_ = pthread_self();

		entry_common(thread->arg_);
		return 0;
	}
	
	void* PThreadRunner::entry(void* arg)
	{
		disableSignals();
		
		entry_common(arg);
		return 0;
	}
}
