/*
Copyright (c) 2006, Jean Gressmann All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

    * 	Redistributions of source code must retain the above copyright
    	notice, this list of conditions and the following disclaimer. 
    *	Redistributions in binary form must reproduce the above copyright
		notice, this list of conditions and the following disclaimer in the
		documentation and/or other materials provided with the distribution.
    * 	The names of its contributors may not be used to endorse or promote products
		derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
 
#ifndef WIN32_SEMAPHORE_H
#define WIN32_SEMAPHORE_H
#include <portablethreads/config.h>
#include <portablethreads/exception.h>
#include <windows.h>

namespace PortableThreads 
{
	namespace OSSpecific
	{
		class PTSemaphore
		{
		public:
			static const pt_uint_t MAX = static_cast<pt_uint_t>(-1) >> 1;
			PTSemaphore(pt_uint_t initially = 0) 
				:	sem_(CreateSemaphore(0, initially > MAX ? MAX : initially, MAX, 0))
			{
				if(sem_ == NULL)
					throw PTResourceError("[PTSemaphore] Could not create semaphore");
			}
		  	
			~PTSemaphore()
			{
				CloseHandle(sem_);
			}
			// try to get a bit of the semaphore's count. If successfull,
			// return true, else false
			inline bool tryDown()
  			{
      			return WaitForSingleObject(sem_, 0) == WAIT_OBJECT_0;			
			}
		    
			// wait for a share of the semaphore's count. Block while
			// waiting
			inline void down()
  			{
    			while(WaitForSingleObject(sem_, INFINITE) != WAIT_OBJECT_0);
			}
			// release one's share of the semaphore's count. Never blocks.
			inline void up()
  			{
    			ReleaseSemaphore(sem_, 1, 0);    		
  			}
		private:
			// Semaphores cannot be copied or assigned
			PTSemaphore(const PTSemaphore&);
  			PTSemaphore& operator=(const PTSemaphore&);
		private:
			HANDLE sem_;
		};
	}
}


#endif
