/*
Copyright (c) 2006, Jean Gressmann All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

    * 	Redistributions of source code must retain the above copyright
    	notice, this list of conditions and the following disclaimer. 
    *	Redistributions in binary form must reproduce the above copyright
		notice, this list of conditions and the following disclaimer in the
		documentation and/or other materials provided with the distribution.
    * 	The names of its contributors may not be used to endorse or promote products
		derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <portablethreads/time.h>
#include <portablethreads/exception.h>
#include <cassert>

// PTime::stamp, sleep functions
#ifdef PT_WINDOWS
#	include <portablethreads/win32/time.cpp> 
#endif
#ifdef PT_UNIX
#	include <portablethreads/unix/time.cpp> 
#endif


namespace PortableThreads
{
	PTime::~PTime()
	{}
	PTime::PTime()
			:	start_(0)
			,	end_(0)
	{
		if(!frequency_)
			throw PTResourceError("[PTime] This platform does not support high performance clocks!");
	}

	PTime::time_type PTime::frequency()
	{
		return frequency_;
	}

	void PTime::start()
	{
		start_ = end_ = now();
	}
	void PTime::stop()
	{ 
		end_ = now();
	}

	PTime::time_type PTime::difference() const
	{
		return end_ - start_;
	}
	
}

