#include <vector>
#include <list>
#include <cppunit/TestCase.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestResult.h>
#include <cppunit/TestSuite.h>
#include <cppunit/extensions/HelperMacros.h>
#include <portablethreads/lockfree/allocator.h>

using namespace std;
using namespace PortableThreads;
using namespace PortableThreads::LockFree;

// There aren't any MT tests here, because the allocator only
// forwards to PTHeap for which MT tests exist.
class AllocatorTest : public CppUnit::TestFixture
{
public:
	typedef std::vector<unsigned, PTAllocator<unsigned> > Vector;
	typedef std::list<unsigned, PTAllocator<unsigned> > List;
	void testDry()
	{
		Vector v;
		List l;
		const unsigned count = 1000;

		for(unsigned i = 0; i < count; ++i)
		{
			v.push_back(i);
			l.push_back(i);
		}

		for(unsigned i = 0; i < count; ++i)
		{
			v.pop_back();
			l.pop_back();
		}
	}
	void testAllocatorChange()
	{
		const unsigned count = 1000;
		List merge;

		{
			List l1, l2;
			for(unsigned i = 0; i < count/2; ++i)
			{
				l1.push_back(i);
			}
			for(unsigned i = count/2; i < count; ++i)
			{
				l2.push_back(i);
			}

			merge.splice(merge.begin(), l1);
			merge.merge(l2);
		}

		List::const_iterator it = merge.begin();
		for(unsigned i = 0; i < count; ++i, ++it)
		{
			CPPUNIT_ASSERT_EQUAL(i, *it);
		}
	}
	
	CPPUNIT_TEST_SUITE( AllocatorTest );
		CPPUNIT_TEST( testDry );
		CPPUNIT_TEST( testAllocatorChange );
	CPPUNIT_TEST_SUITE_END();
};


//CPPUNIT_TEST_SUITE_REGISTRATION( AllocatorTest );



