#ifdef WIN32
#	include <windows.h>
#else
#	include <unistd.h>
#endif
#include "ticks.h"

uint64 ticks()
{
#ifdef _MSC_VER
	#pragma warning(disable:4035)
	__asm rdtsc;
	#pragma warning(disable:4035)
#else
	volatile uint64 val = 0;
    asm ("rdtsc" : "=r" (val));
    return val;
#endif
}

namespace
{
	uint64 ticksPerSecondImpl()
	{
		const int AVG = 1;
		uint64 sum = 0, start = 0;
		for(int i = 0; i < AVG; ++i)
		{
			start = ticks();
	#ifdef _MSC_VER	
			Sleep(10);	
	#else
			sleep(10);
	#endif
			sum += ticks() - start;
		}
		return sum/10/*AVG*/;
	}
	const uint64 tps = ticksPerSecondImpl();
}

uint64 frequency()
{
	return tps;
}
