/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/
#ifndef LIBNOMORE_HYBRID_LOOKAHEAD_HEURISTIC_H
#define LIBNOMORE_HYBRID_LOOKAHEAD_HEURISTIC_H

#include <operators/hybrid_lookahead.h>
#include <lookahead_heuristic.h>

namespace NS_NOMORE {

//! Heuristic strategy that compares nodes rated by HybridLookahead operator.
/*! 
 *  The result of the HybridLookahead operator is a long-value which 
 *  represents the number of nodes which become decided if the node is 
 *  colored as choice point. This Strategy prefers the node with the greatest 
 *  value and works for head and body nodes.
 *
 *  \note This heuristic does not evalute the heuristic value of a node it 
 *        takes the results of the hybrid lookahead. It is important to 
 *        enable the HybridLookahead. If not the heuristic returns no choice 
 *        points.
 *
 *  \see HybridLookaheadHeuristic */
class HybridLookaheadHeuristicStrat {
public:
  //! Type of the base for the heuristic.
  typedef HybridLAHeuristicBase BaseType;

  //! The value type of the heuristic.
  typedef BaseType::HeuristicValueType ValueType;

  //! The comparator type of the heuristic.
  typedef std::greater<ValueType> ComparatorType;
};

//! Type definition of the hybrid lookahead strategy HybridLookaheadHeuristicStrat.
typedef LookaheadHeuristic<HybridLookaheadHeuristicStrat> HybridLookaheadHeuristic;

}
#endif
