/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/
#ifndef NOMORE_OPERATOR_H
#define NOMORE_OPERATOR_H

#include <color.h>

namespace NS_NOMORE {

class Graph;

//! The base class for all nomore operators.
/*!
 *  This class has an abstract method to which executes the operator and
 *  the the standard implementations for reseting the operators members.*/
class Operator {
public:
  //! Creates a new operator.
  Operator();
  
  //! Destroys the operator.
  virtual ~Operator();

  //! Executes this operator.
  /*!
   *  \return True if the operator executed successfully. False otherwise. */
  virtual bool operator()() = 0;

  //! Resets this operator.
  /*!
   *  Concrete operators may overwrite this method for example to clear 
   *  internal queues.
   *
   *  \note The default implementation does nothing. */
  virtual void reset();

  //! Returns the name of the concrete operator type.
  /*!
   *  \return The name of the concrete operator. */
  virtual const char* getName() const = 0;

private:
  // deny constructors
  Operator(const Operator&);
  Operator& operator=(const Operator&);
};

//! Returns the name for a concrete operator.
/*!
 *  \param T The type of the operator. 
 *  \return The name of the operator T. */
template <class T>
const char* getName(T*);

}

#endif
