/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#include <node.h>

namespace NS_NOMORE {

Node::Node(long id, NodeType::Value type) 
  : id_(id)
  , type_(type)
  , color_(Color::none)
  , componentNumber_(0) {

}

Node::~Node() {
}

ColorOpResult Node::setColor(Color::ColorValue c) {
  assert(c != Color::none);
  ColorOpResult res = ColorOperation::failed;
	if( c == color_ || (c == Color::weak_plus && color_ == Color::plus) ) {
    res = ColorOperation::unchanged;
  }
  else if(isValidColoring(color_, c)) {
    Color::ColorValue oldColor = color_;
    color_ = c;

    doSetColor(oldColor);

    res = ColorOperation::succeeded;
  }
  else {
    res = ColorOperation::failed;
  }
  return res;
}

double Node::getTightnessFactor(int /* gradient */) const {
  return 1.0;
}

} // NS_NOMORE
