/*	$Id: kernel.h 8281 2007-11-10 13:45:35Z martin $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef KERNEL_H
#define KERNEL_H

#include <memory>
#include <platypus/types_fwd.h>
#include <platypus/types/choice.h>
#include <platypus/types/search_space.h>

class NopStream;
namespace Platypus
{
	class KernelCallback
	{
	public:
		virtual ~KernelCallback()
		{}
		virtual bool shutdown() = 0;
		// remote 
		virtual bool needDelegatableChoice() = 0;
		virtual void delegate(const DelegatableChoice& dc) = 0;
		// local
		virtual bool needBranch() = 0;
		virtual void branch(const DelegatableChoice& dc) = 0;
		virtual Expander* expander(const Branch& dc = Branch()) = 0; 
		virtual DelegatableChoicePolicy::PolicyBase* delegatableChoicePolicy() = 0;
		virtual DelegatableChoicePolicy::PolicyBase* threadDelegationPolicy() = 0;
		virtual ProbingPolicy::PolicyBase* probingPolicy() = 0;
		virtual void answerSet(const PartialAssignment& pa) = 0;
		virtual void markConflict() = 0;
		virtual void markAnswerSet() = 0;
		virtual void markBacktrack() = 0;
		virtual void markExpanderInitialization() = 0;
		virtual int processId() const = 0;
		virtual int threadId() const = 0;
		virtual bool silent() const = 0;
		virtual ProbingManager* probingManager() = 0;
		virtual NopStream* output() = 0;
		virtual size_t atoms() const = 0;
		virtual void startExpansion() = 0;
		virtual void finishExpansion() = 0;
		virtual void startExpanderReinitialization() = 0;
		virtual void finishExpanderReinitialization() = 0;
	};

	
	class Kernel
	{
	public:
		~Kernel();
		Kernel(KernelCallback* callback = 0);
		void setCallback(KernelCallback& callback);
		void configure();
		void run(const Branch& dc);
	private:
		Kernel(const Kernel&);
		Kernel& operator=(const Kernel&);
		bool iteration();
		bool answerSet();
		bool conflict();
		bool expand();
		bool backtrack();
		void initialize();
		void delegate();
		void branch();
	private:
		SearchSpace space_;
		ChoicesToDo* choicesToDo_;
		KernelCallback* callback_;
		NopStream* os_;
		std::auto_ptr<DelegatableChoicePolicy::PolicyBase> dcPolicy_, threadDelegationPolicy_;
		std::auto_ptr<ProbingPolicy::PolicyBase> probingPolicy_;
		std::auto_ptr<ProbingManager> probing_;
		std::auto_ptr<Expander> expander_;
		size_t atoms_;
		bool suppressAnswerSetPrinting_;
	};
}

#endif
