/*	$Id: exceptions.h 2140 2005-07-03 11:28:23Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef PLATYPUS_EXCEPTIONS_H
#define PLATYPUS_EXCEPTIONS_H

#include <platypus/types/exceptions.h>

namespace Platypus
{
	class CommandlineError : public PlatypusException
	{
	public:
		CommandlineError(const std::string& reason = "Incompatible/invalid combination of command line arguments specified!")
			:	PlatypusException(reason)
		{}
	};

	class NullPointerException : public PlatypusException
	{
	public:
		NullPointerException(const std::string& reason = "Passed a null pointer!")
			:	PlatypusException(reason)
		{}
	};

	// Thrown to indicate that an named input (a file) could not opened
	class InputError : public PlatypusException
	{
	public:
		InputError(const std::string& reason = "Could not open input for reading")
			:	PlatypusException(reason)
		{}
	};

	class IPCError : public PlatypusException
	{
	public:
		IPCError(const std::string& reason = "There is a problem with inter process communication")
			:	PlatypusException(reason)
		{}
	}; 
}

#endif
