/*	$Id: smodels_expander.h 2058 2005-06-29 07:52:37Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef SMODELS_EXPANDER_H
#define SMODELS_EXPANDER_H

#include <smartpointer.h>
#include <platypus/types/choice.h>
#include <platypus/types/partial_assignment.h>
#include <platypus/types/expander.h>

namespace Platypus
{
	class SmodelsEnhancedProgram;
	class SmodelsExpanderImpl;
	class SmodelsExpander	:	public Expander
							,	public Backtrackable
							,	public Choosable
	{
	public:
		~SmodelsExpander();
		SmodelsExpander(const ProgramInterface& program, const DelegatableChoice& dc = DelegatableChoice());
		static Expander* create(const ProgramInterface& program, const DelegatableChoice& dc = DelegatableChoice());

		bool hasUnknown() const;
		bool hasConflict() const;
		
		// returns a PartialModel representation of the internal
		// partial model. 
		PartialAssignment partialAssignment() const;
		
		// return the set of atoms that are currently unknown
		// (In case we want to do the choosing ourselves ;-)
		PossibleChoices possibleChoices() const;

		size_t unknownAtoms() const;
	private:
		void strategyExpand(const Choice& choice);
		void strategyReinitialize(const DelegatableChoice&);
		void strategyBacktrackTo(const Choice&);
		Choice strategyGetChoice();	
		void destroyDictionary();
	private:
		const SmodelsEnhancedProgram* program_;
		SmodelsExpanderImpl* pimpl_;
		toolbox::SmartPtr<char, toolbox::ArrayPointerTraits_<char> > rawExpander_;
		toolbox::SmartPtr<char, toolbox::ArrayPointerTraits_<char> > rawDictionary_;
	};
}

#endif

