/*	$Id: choices_to_do.cpp 2253 2005-07-23 13:55:11Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include <platypus/exceptions.h>
#include <platypus/types/choices_to_do.h>

namespace Platypus
{
	ChoicesToDo::~ChoicesToDo()
	{
		if(space_)
			space_->close(active_);
	}
	ChoicesToDo::ChoicesToDo(SearchSpace& space)
		:	space_(&space)
		,	localRoot_(space_->root())
		,	coreEnd_(space_->root())
		,	active_(coreEnd_)
	{
		active_->active(true);
	}
	ChoicesToDo::ChoicesToDo(SearchSpace& space, SearchSpace::cursor coreEnd)
		:	space_(&space)
		,	localRoot_(coreEnd)
		,	coreEnd_(coreEnd)
		,	active_(coreEnd_)
	{
		active_->active(true);
	}
	void ChoicesToDo::release()
	{
		active_->active(false);
		space_ = 0;
	}
	void ChoicesToDo::add(const Choice& choice)
	{
		active_ = space_->add(active_, choice);
		active_->active(true);
	}
	
	bool ChoicesToDo::hasChoice() const
	{
		SearchSpace::cursor c = active_;
		for(SearchSpace::cursor parent = c.parent();
			c != localRoot_; parent.ascend())
		{
			assert(parent.good());
			if(parent.has_left_child() && parent.has_right_child())
				return true;
			c = parent;
		}
		return false;
	}
	
	Choice ChoicesToDo::nextChoice()
	{
		if(!hasChoice())
			throw NoChoiceLeft();
		// close active branch and move up to the last open choice
		active_ = space_->close(active_);
		assert(active_.has_left_child() || active_.has_right_child());
		assert(!(active_.has_left_child() && active_.has_right_child()));
		active_->active(true);
		coreEnd_ = localRoot_;
		bool left;
		if(active_.has_left_child())
		{
			left = true;
			active_.descend_left();			
		}
		else
		{
			left = false;
			active_.descend_right();
		}
		assert(!active_.has_left_child() && !active_.has_right_child());
		active_->active(true);
		return Choice(active_->id(), left);
	}
	void ChoicesToDo::extendCore()
	{
		while(true)
		{
			// either totally open on both ends or a true leaf
			if(coreEnd_.has_left_child() == coreEnd_.has_right_child())
				break;

			if(coreEnd_.has_left_child())
				coreEnd_.descend_left();
			else
				coreEnd_.descend_right();
		}
	}
	Branch ChoicesToDo::core()
	{
		extendCore();
		return space_->branch(coreEnd_);
	}
	void ChoicesToDo::swap(ChoicesToDo& other)
	{
		std::swap(space_, other.space_);
		localRoot_.swap(other.localRoot_);
		coreEnd_.swap(other.coreEnd_);
		active_.swap(other.active_);
	}
}

