#include <iostream>
#include <cppunit/TestCase.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestResult.h>
#include <cppunit/TestSuite.h>
#include <cppunit/extensions/HelperMacros.h>
#include <portablethreads/config.h>

#define PT_ARCH_COMMON_INCLUDED

#include <portablethreads/arch/ia-64-muxer.h>


using namespace std;
using namespace PortableThreads;
using namespace PortableThreads::LockFree;

#ifdef _MSC_VER
#	pragma warning(disable:4311) // pointer to int
#	pragma warning(disable:4312) // int to pointer
#endif


template<typename Muxer>
class IA64MuxerTest : public CppUnit::TestFixture
{
public:
	typedef typename Muxer::int_t int_t;
	IA64MuxerTest()
	{
		CPPUNIT_ASSERT(sizeof(int_t) >= 8);
	}

	void testCombination(int_t p, int_t count, int_t userbits, bool testcount)
	{
		int_t mux = Muxer::multiplex(p, count, userbits);
		CPPUNIT_ASSERT_EQUAL(p, Muxer::pointer(mux));
		CPPUNIT_ASSERT_EQUAL(userbits, Muxer::userbits(mux));
		if(testcount)
			CPPUNIT_ASSERT_EQUAL(count, Muxer::count(mux));
	}
	void testPointerIsZero()
	{
		int_t p = 0;
		testCombination(p, 0, 0, true);
		testCombination(p, 0, 1, true);
		testCombination(p, 0, 2, true);
		testCombination(p, 0, 3, true);
		testCombination(p, 32767, 0, true);
		testCombination(p, 32767, 1, true);
		testCombination(p, 32767, 2, true);
		testCombination(p, 32767, 3, true);
		
		int_t count = static_cast<int_t>(1) << Muxer::freeBits();
		testCombination(p, count, 0, false);
		testCombination(p, count, 1, false);
		testCombination(p, count, 2, false);
		testCombination(p, count, 3, false);
	}

	void testTagIs101PointerIsZero()
	{
		int_t p = 5;
		p <<= Muxer::pointerBits() - Muxer::tagBits();

		testCombination(p, 0, 0, true);
		testCombination(p, 0, 1, true);
		testCombination(p, 0, 2, true);
		testCombination(p, 0, 3, true);
		testCombination(p, 32767, 0, true);
		testCombination(p, 32767, 1, true);
		testCombination(p, 32767, 2, true);
		testCombination(p, 32767, 3, true);
		
		int_t count = static_cast<int_t>(1) << Muxer::freeBits();
		testCombination(p, count, 0, false);
		testCombination(p, count, 1, false);
		testCombination(p, count, 2, false);
		testCombination(p, count, 3, false);
	}
	void testTagIs010PointerIsAllOnes()
	{
		int_t p = ~0; // ones
		p &= ~(7); // alignment
		p &= ~(static_cast<int_t>(7) << (Muxer::pointerBits() - Muxer::tagBits()));
		int_t tag = static_cast<int_t>(4) << (Muxer::pointerBits() - Muxer::tagBits());
		p ^= tag;

		testCombination(p, 0, 0, true);
		testCombination(p, 0, 1, true);
		testCombination(p, 0, 2, true);
		testCombination(p, 0, 3, true);
		testCombination(p, 32767, 0, true);
		testCombination(p, 32767, 1, true);
		testCombination(p, 32767, 2, true);
		testCombination(p, 32767, 3, true);
		
		int_t count = static_cast<int_t>(1) << Muxer::freeBits();
		testCombination(p, count, 0, false);
		testCombination(p, count, 1, false);
		testCombination(p, count, 2, false);
		testCombination(p, count, 3, false);

		
	}
	void testTagIs010PointerRealisticMSBIsOne()
	{
		int_t p = ~0; // ones
		p &= ~(7); // alignment
		p &= ~(static_cast<int_t>(7) << (Muxer::pointerBits() - Muxer::tagBits()));
		int_t tag = static_cast<int_t>(4) << (Muxer::pointerBits() - Muxer::tagBits());
		p ^= tag;
		p ^= static_cast<int_t>(0xdeadbeef) << 3;

		testCombination(p, 0, 0, true);
		testCombination(p, 0, 1, true);
		testCombination(p, 0, 2, true);
		testCombination(p, 0, 3, true);
		testCombination(p, 32767, 0, true);
		testCombination(p, 32767, 1, true);
		testCombination(p, 32767, 2, true);
		testCombination(p, 32767, 3, true);
		
		int_t count = static_cast<int_t>(1) << Muxer::freeBits();
		testCombination(p, count, 0, false);
		testCombination(p, count, 1, false);
		testCombination(p, count, 2, false);
		testCombination(p, count, 3, false);
	}
	void testTagIs101PointerRealisticMSBIsZero()
	{
		int_t p = static_cast<int_t>(0xdeadbeef) << 3; // ones
		int_t tag = static_cast<int_t>(5) << (Muxer::pointerBits() - Muxer::tagBits());
		p ^= tag;
		
		testCombination(p, 0, 0, true);
		testCombination(p, 0, 1, true);
		testCombination(p, 0, 2, true);
		testCombination(p, 0, 3, true);
		testCombination(p, 32767, 0, true);
		testCombination(p, 32767, 1, true);
		testCombination(p, 32767, 2, true);
		testCombination(p, 32767, 3, true);
		
		int_t count = static_cast<int_t>(1) << Muxer::freeBits();
		testCombination(p, count, 0, false);
		testCombination(p, count, 1, false);
		testCombination(p, count, 2, false);
		testCombination(p, count, 3, false);
	}
	
	CPPUNIT_TEST_SUITE( IA64MuxerTest );
		CPPUNIT_TEST( testPointerIsZero );
		CPPUNIT_TEST( testTagIs101PointerIsZero );
		CPPUNIT_TEST( testTagIs010PointerIsAllOnes );
		CPPUNIT_TEST( testTagIs010PointerRealisticMSBIsOne );
		CPPUNIT_TEST( testTagIs101PointerRealisticMSBIsZero );
	CPPUNIT_TEST_SUITE_END();
};
typedef ::PortableThreads::LockFree::Private::IA64Muxer< ::PortableThreads::int64, 50, 3, 2> IA64LikeMuxer;

typedef IA64MuxerTest< IA64LikeMuxer > IA64Test;


CPPUNIT_TEST_SUITE_REGISTRATION( IA64Test ); 



