
#include <iostream>
#include <cassert>
#include <portablethreads/config.h>

using namespace std;



template<typename T>
typename PortableThreads::Private::PTCompilerHelper<T>::uint_type 
unsigned_cast(T i)
{
	typedef typename PortableThreads::Private::PTSizeToType<sizeof(T)>::uint_type target_int_type;
	if(PortableThreads::Private::PTSign<T>::sign)
		return *reinterpret_cast<target_int_type*>(&i);
	return i;
}

template<typename T>
typename PortableThreads::Private::PTCompilerHelper<T>::int_type 
signed_cast(T i)
{
	if(!PortableThreads::Private::PTSign<T>::sign)
		return *reinterpret_cast<typename PortableThreads::Private::PTCompilerHelper<T>::int_type*>(&i);
	return i;
}
using namespace PortableThreads;
// VA layout: [3 bit tag|extended from MSB|pointer data]
template<
	typename T, 
	unsigned HARDWARE_POINTER_BITS, 
	unsigned ALIGNMENT_BITS = 0, 
	unsigned USER_BITS = 0, 
	unsigned COUNTER_BITS = POINTER_BITS - TAG_BITS - HARDWARE_POINTER_BITS - 1 + ALIGNMENT_BITS - USER_BITS
>
struct FreeHighBitsMuxer
{
	enum { POINTER_BITS = 64, TAG_BITS = 3 };
	typedef T int_t;
	typedef ::PortableThreads::LockFree::Private::token_t<COUNTER_BITS, USER_BITS> token_t;
	static inline int_t multiplex(int_t pointer, int_t count, int_t userbits)
	{
		// create: [tag|half-indicator bit|pointer|count|userbits]
		assert(HARDWARE_POINTER_BITS <= POINTER_BITS);
		assert(ALIGNMENT_BITS < HARDWARE_POINTER_BITS);
		assert(sizeof(T)*8 - HARDWARE_POINTER_BITS + ALIGNMENT_BITS - USER_BITS - COUNTER_BITS >= 0);						

		// Make sure the aligment assumption holds
		assert((pointer & ALIGNMENT_MASK) == 0);

		// Make sure user bits don't occupy anything else
		assert((userbits & ~USER_BITS_MASK) == 0);

		// counter must fit in reserved bits
		count %= COUNTER_MAX;

		if(COUNTER_BITS && USER_BITS) // compiler optimizes this away...
			count <<= USER_BITS;

		// move pointer to high region
		const int_t tag = pointer & TAG_MASK;
		pointer &= POINTER_MASK;
		pointer <<= POINTER_SHIFT;
		assert((pointer & TAG_MASK) == 0);
		assert((pointer & (COUNTER_MASK << USER_BITS)) == 0);
		assert((pointer & USER_BITS_MASK) == 0);

		if(USER_BITS)
			pointer ^= userbits;

		if(COUNTER_BITS) // compiler optimizes this away...
			pointer ^= count;

		return pointer ^ tag;
	}
	static inline int_t userbits(int_t mux)
	{
		return mux & USER_BITS_MASK;
	}
	static inline int_t count(int_t mux)
	{
		return (mux >> USER_BITS) & COUNTER_MASK;
	}
	static inline int_t pointer(int_t mux)
	{
		// [tag|half-indicator bit|pointer|count|userbits] -> [tag||half-indicator bit spread|pointer]
		const int_t tag = pointer & TAG_MASK;
		const bool zerofill = (mux & MSB_MASK) == 0;
		// put pointer back into place
		mux >>= POINTER_SHIFT;
		// clear alignment bits
		mux &= ~ALIGNMENT_MASK;
		// clear high bits
		mux &= POINTER_MASK;
		// fill unimplemented bits according to zerofill bit
		if(!zerofill)
			mux ^= HIGH_ONES;

		return mux ^ tag;
	}
	static inline int_t freeBits()
	{
		return POINTER_BITS - HARDWARE_POINTER_BITS;
	}
	static inline int_t counterBits()
	{
		return COUNTER_BITS;
	}
	static inline int_t pointerBits()
	{
		return POINTER_BITS;
	}
	static inline int_t hardwarePointerBits()
	{
		return HARDWARE_POINTER_BITS;
	}
	static inline int_t alignmentBits()
	{
		return ALIGNMENT_BITS;
	}
	static inline int_t userBits()
	{
		return USER_BITS;
	}
private:
	static const int_t TAG_MASK = ((static_cast<int_t>(1) << TAG_BITS) - 1) << (POINTER_BITS - TAG_BITS);
	static const int_t MSB_MASK = static_cast<int_t>(1) << (POINTER_BITS - 1 - TAG_BITS);
	static const int_t COUNTER_MAX = static_cast<int_t>(1) << COUNTER_BITS;
	static const int_t COUNTER_MASK = COUNTER_MAX - 1;
	static const int_t USER_BITS_MASK = (static_cast<int_t>(1) << USER_BITS) - 1;
	static const int_t ALIGNMENT_MASK = (static_cast<int_t>(1) << ALIGNMENT_BITS) - 1;
	// only shift in case the hardware pointer is smaller than the virtual pointer
	static const int_t POINTER_SHIFT = POINTER_BITS - HARDWARE_POINTER_BITS - 1 - TAG_BITS;
	static const int_t HIGH_ONES = ((static_cast<int_t>(1) << (POINTER_BITS - HARDWARE_POINTER_BITS - TAG_BITS)) - 1) << HARDWARE_POINTER_BITS;
	// mask of high bits, only nessary if hardware pointer is smaller than virtual pointer
	static const int_t POINTER_MASK = (static_cast<int_t>(1) << HARDWARE_POINTER_BITS) - 1;
};
int main()
{

	int64 x = 0;

	
 	return 0;
}