// $Id: main.cpp 1778 2005-05-17 14:37:06Z jgressma $

#include <iostream>
#include <fstream>
#include <exception>
#include <memory>
#include <portablethreads/time.h>
#include <regression/test.h>
#include <regression/test_factory.h>
#include <regression/test_runner.h>
#ifdef _MSC_VER
	#include <crtdbg.h>
#endif

using namespace std;
using namespace PortableThreads;

int main(int argc, char* argv[])
{
#ifdef _MSC_VER
	if(1)
	{
		_CrtSetDbgFlag(_CrtSetDbgFlag(_CRTDBG_REPORT_FLAG) |
					_CRTDBG_LEAK_CHECK_DF | _CRTDBG_ALLOC_MEM_DF |
		_CRTDBG_CHECK_ALWAYS_DF);
		_CrtSetReportMode( _CRT_WARN, _CRTDBG_MODE_FILE );
		_CrtSetReportFile( _CRT_WARN, _CRTDBG_FILE_STDERR );
		_CrtSetReportMode( _CRT_ERROR, _CRTDBG_MODE_FILE );
		_CrtSetReportFile( _CRT_ERROR, _CRTDBG_FILE_STDERR );
		_CrtSetReportMode( _CRT_ASSERT, _CRTDBG_MODE_FILE );
		_CrtSetReportFile( _CRT_ASSERT, _CRTDBG_FILE_STDERR );
	}
#endif
	
	istream* input = &cin;
	ifstream file;
	if(argc == 2)
	{
		file.open(argv[1]);
		if(!file)
		{
			cerr << "Could not open file '" << argv[1] << "' for reading!" << endl;
			return 1;
		}
		input = &file;
		cout << "Reading from file '" << argv[1] << "'..." << endl;
	}
	else
	{
		cout << "Reading from stdin..." << endl;
	}

	try
	{
		PTime stopwatch;
		stopwatch.start();
		cout << "Creating test objects..." << endl;
		auto_ptr<Regression::TestRunner> runner(Regression::TestFactory::create(*input));
		stopwatch.stop();

		cout.precision(2);
		cout << "Test creation time: " << (stopwatch.difference()*1.0)/(stopwatch.frequency()*1.0) << " seconds." << endl;

		stopwatch.start();
		runner->run();
		stopwatch.stop();

		cout << "Test time: " << (stopwatch.difference()*1.0)/(stopwatch.frequency()*1.0) << " seconds." << endl;
	}
	catch(const Regression::TerminateProcess&)
	{
		// do nothing, just exit
	}
	catch(const exception& e)
	{
		cerr << Regression::TEST_FAILURE << endl;
		cerr << e.what() << endl;
		return 1;
	}
	catch(...)
	{
		cerr << Regression::TEST_FAILURE << endl;
		cerr << "Unknown  error, exiting!" << endl;
		return 1;
	}
	
	

	return 0;
}
