#include <iostream>
#include <fstream>
#include <string>
#include <sstream>
#include <memory>
#include <cppunit/TestCase.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestResult.h>
#include <cppunit/TestSuite.h>
#include <cppunit/extensions/HelperMacros.h>
#include <test/smodels_helper.h>
#include <platypus/smodels/smodels_wrapper.h>


using namespace std;
using namespace Platypus;

class SmodelsWrapperTest : public CppUnit::TestFixture
{
	typedef std::auto_ptr<SmodelsHolder> SafeHolder;
	typedef std::auto_ptr<Smodels> SafeSmodels;
public:	
	void dualCalc(const char* filename, const char* checkagainst = 0)
	{
		ifstream in(filename);
		CPPUNIT_ASSERT(in);
		SmodelsHolderFactory f(in);
		
		SafeHolder h1(f.create());
		CPPUNIT_ASSERT(h1.get() != 0);
		SafeHolder h2(f.create());
		CPPUNIT_ASSERT(h2.get() != 0);

		SafeSmodels s1(h1->finalize());
		SafeSmodels s2 (h2->finalize());

		
		stringstream ass1, ass2;
		ass1 << *s1.get();
		ass2 << *s2.get();
		const string result(ass1.str());
		CPPUNIT_ASSERT(answerSetCompare(ass1, ass2));

		if(checkagainst)
		{	
			stringstream s(result);
			ifstream check(checkagainst);
			CPPUNIT_ASSERT(check);

			if(0)
			{
				ofstream out("result.txt");
				CPPUNIT_ASSERT(out);
				out << result;
				out.close();
			}

			CPPUNIT_ASSERT(answerSetCompare(s, check));
		}
	}
	void testUsualcases()
	{
		dualCalc("usualcases.lparse", "usualcases.lparse.smodels");
	}
	void testSchur()
	{
		dualCalc("schur-3-3.lparse", "schur-3-3.lparse.smodels");
		dualCalc("schur-6-3.lparse", "schur-6-3.lparse.smodels");
	}
	void testColor3_4()
	{
		dualCalc("color-3-4.lparse", "color-3-4.lparse.smodels");
	}
	void testHam_comp()
	{
		dualCalc("ham_comp_3.lparse", "ham_comp_3.lparse.smodels");
		dualCalc("ham_comp_4.lparse", "ham_comp_4.lparse.smodels");
		dualCalc("ham_comp_5.lparse", "ham_comp_5.lparse.smodels");
	}
	void testQueens()
	{
		dualCalc("4queens.lparse", "4queens.lparse.smodels");
		dualCalc("5queens.lparse", "5queens.lparse.smodels");
	}
	void testRealChoice()
	{
		dualCalc("realchoice1.lparse", "realchoice1.lparse.smodels");
		dualCalc("realchoice2.lparse", "realchoice2.lparse.smodels");
		dualCalc("realchoice3.lparse", "realchoice3.lparse.smodels");
	}
	CPPUNIT_TEST_SUITE( SmodelsWrapperTest );
		CPPUNIT_TEST( testUsualcases );	
		CPPUNIT_TEST( testSchur );
		CPPUNIT_TEST( testColor3_4 );
		CPPUNIT_TEST( testHam_comp );
		CPPUNIT_TEST( testQueens );
		CPPUNIT_TEST( testRealChoice );
	CPPUNIT_TEST_SUITE_END();
};


CPPUNIT_TEST_SUITE_REGISTRATION( SmodelsWrapperTest );

